/*
 * Decompiled with CFR 0.152.
 */
package com.item_article.domain.use_case;

import com.category.domain.model.ProductCategory;
import com.category.domain.use_case.product_category.AddProductCategory;
import com.category.domain.use_case.product_category.FilterExistingProductCats;
import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.item_article.domain.use_case.AddCategoryToProduct;
import com.item_article.domain.use_case.AddItemArticle;
import com.item_article.domain.use_case.GetItemArticle;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AddCategoryToProduct {
    private final DbConnection dbConnection;
    private final FilterExistingProductCats filterExistingProductCats;
    private final GetItemArticle getItemArticle;
    private final AddProductCategory addProductCategory;
    private final AddItemArticle addItemArticle;

    public synchronized Map<String, Object> invoke(@NotNull ItemArticleDto itemArt, LoginDto login) {
        return (Map)this.dbConnection.getTransactionTemplate(login).execute(status -> this.insideInvoke(itemArt, login));
    }

    @NotNull
    private Map<String, Object> insideInvoke(@NotNull ItemArticleDto itemArt, LoginDto login) {
        List categoryIds = itemArt.splitCategories();
        List pCatsToInsert = this.filterExistingProductCats.invoke(categoryIds);
        AddProductCatResult result = this.getAddProductCatResult(pCatsToInsert, login);
        itemArt.setPoshakid(result.id);
        this.checkExistingItemArticle(itemArt, login);
        long itemArtId = this.addItemArticle.invoke(itemArt, login);
        return this.makeResult(itemArtId, result);
    }

    private void checkExistingItemArticle(@NotNull ItemArticleDto itemArt, LoginDto login) throws TncException {
        List existingItemArticle = this.getItemArticle.getAll("WHERE A_CODE = '" + itemArt.getA_code() + "' AND PoshakId = " + itemArt.getPoshakid(), login);
        if (!existingItemArticle.isEmpty()) {
            throw new TncException(TncExceptionMessages.ALREADY_ASSIGNED_CATEGORY);
        }
    }

    @NotNull
    private Map<String, Object> makeResult(long itemArtId, AddProductCatResult result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", itemArtId);
        resultMap.put("added_product_category_ids", result.insertedPCatIds);
        return resultMap;
    }

    @NotNull
    private AddProductCatResult getAddProductCatResult(List<ProductCategory> pCatsToInsert, LoginDto login) {
        long leafPoshakID = -1L;
        ArrayList<Long> insertedPCatIds = new ArrayList<Long>();
        if (!pCatsToInsert.isEmpty() && pCatsToInsert.stream().allMatch(category -> category.getPid() == null)) {
            return new AddProductCatResult((long)pCatsToInsert.get(0).getParentid().intValue(), insertedPCatIds);
        }
        int tmpParentId = 0;
        for (int i = 0; i < pCatsToInsert.size(); ++i) {
            boolean isLastItem;
            ProductCategory pCat = pCatsToInsert.get(i);
            if (pCat.getParentid() == null) {
                pCat.setParentid(Integer.valueOf(tmpParentId));
            }
            long pCatInsertId = this.addProductCategory.invoke(pCat, login);
            tmpParentId = (int)pCatInsertId;
            insertedPCatIds.add(pCatInsertId);
            boolean bl = isLastItem = i == pCatsToInsert.size() - 1;
            if (!isLastItem) continue;
            leafPoshakID = pCatInsertId;
        }
        return new AddProductCatResult(leafPoshakID, insertedPCatIds);
    }

    public AddCategoryToProduct(DbConnection dbConnection, FilterExistingProductCats filterExistingProductCats, GetItemArticle getItemArticle, AddProductCategory addProductCategory, AddItemArticle addItemArticle) {
        this.dbConnection = dbConnection;
        this.filterExistingProductCats = filterExistingProductCats;
        this.getItemArticle = getItemArticle;
        this.addProductCategory = addProductCategory;
        this.addItemArticle = addItemArticle;
    }
}

